function DrawStat(stat, x, y, width)
    if width ~= nil then
        love.graphics.printf(stat.value(), x, y, width, 'center')
    else
        love.graphics.print(stat.value(), x, y)
    end

    local r, g, b = love.graphics.getColor()

    for i, change in pairs(stat.changes()) do
        love.graphics.push("all")
        love.graphics.setColor(r, g, b, 1 - change.completion *
                                   change.completion * change.completion)
        local value = change.value
        if change.value > 0 then value = "+" .. value end
        love.graphics.print(value, (20 * i) + x + change.completion * 10 - 5,
                            y + change.completion * change.completion * 10)
        love.graphics.pop()
    end
end
