require "view/drawcards"

HandShortcuts = {'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l'}

function DrawHand(game, player, events)
    love.graphics.push("all")

    love.graphics.translate(15, 340)

    local rows = 2

    local columns = 12
    local cellSize = 97
    local boardWidth = 920
    local handWidth = cellSize * columns
    local handScale = boardWidth / handWidth
    love.graphics.scale(handScale, handScale)

    local hand = game.currentPlayer().hand

    if game.selectedElement() ~= nil then hand = game.filteredCardsInHand() end

    for i, card in ipairs(hand) do
        local opacity = If(game.cardIsPlayable(player, card), 1, 0.5)

        local selectionOffset = 0
        if card == player.selectedCard and game.cardIsPlayable(player, card) then
            selectionOffset = -5
        end

        local column = math.floor((i - 1) / rows)
        local row = (i - 1) % rows

        local x = column * cellSize
        local y = row * cellSize + selectionOffset

        DrawCard(events, game, card, x, y, opacity)

        if ClickedInside(x, y, cellSize, cellSize) then
            table.insert(events, function(game) game.selectCard(card) end)
        end

        -- local shortcut = HandShortcuts[i]
        -- if shortcut == nil then
        --     shortcut = ""
        -- end
        -- love.graphics.printf(shortcut, x, y - 12 + selectionOffset, card_width, "center")
    end

    love.graphics.pop()
end

function TestHandKeys(key, events)
    for i, v in ipairs(HandShortcuts) do
        if v == key then
            table.insert(events, function(game)
                local cards = game.filteredCardsInHand()
                game.selectCard(cards[i])
            end)
        end
    end
end
