require "assets"
require "utils"

local function drawEffects(game, card)
    local effectWidth = 15
    local effectsX = 23
    local effectsY = 3

    local offset = 0
    for _, effect in pairs(game.effects(card)) do
        love.graphics.draw(assets["icon_" .. effect],
                           effectsX + offset * effectWidth, effectsY)
        offset = offset + 1
    end
end

function DrawCard(events, game, card, x, y, opacity)
    love.graphics.push("all")
    love.graphics.translate(x, y)
    love.graphics.setColor(0xFF, 0xFF, 0xFF, opacity);

    love.graphics.draw(CardImage(assets, card.name), 0, 0)

    love.graphics.setColor(ColorWithOpacity(colors.white, opacity))
    love.graphics.setFont(card_font)

    love.graphics.printf(card.name, -10, 70, 110, "center")

    love.graphics.printf(card.level, 75, 3, 17, "center")

    local canCast = game.canCast(card)
    local casterCard = game.casterCard(card)

    if canCast then
        love.graphics.draw(assets.cast_button, 26, 53)
    elseif not canCast and casterCard then
        love.graphics.draw(assets.cast_button_passive, 26, 53)
    end

    local cast_x, cast_y, cast_width, cast_height = 26, 53,
                                                    assets.cast_button:getWidth(),
                                                    assets.cast_button:getHeight()

    if canCast and ClickedInside(cast_x, cast_y, cast_width, cast_height) then
        table.insert(events, function(game) game.cast(card) end)
    end

    if card.health ~= nil then DrawStat(card.health, 7, 52) end

    drawEffects(game, card)

    if card.attack ~= nil then
        love.graphics.setColor(ColorWithOpacity(colors.black, opacity))
        DrawStat(card.attack, 75, 52)
    end

    love.graphics.pop()
end
