function ClickedInside(insideX, insideY, insideW, insideH)
    if not mouse.clicked then return false end
    local clickedX, clickedY = love.graphics.inverseTransformPoint(
                                   mouse.clicked.x, mouse.clicked.y)
    if mouse.clicked ~= nil and
        IsInside(clickedX, clickedY, insideX, insideY, insideW, insideH) then
        return true
    end
    return false
end

function MousePosition()
    return love.graphics.inverseTransformPoint(love.mouse.getPosition())
end

function MouseOver(insideX, insideY, insideW, insideH)
    local overX, overY = MousePosition()
    return IsInside(overX, overY, insideX, insideY, insideW, insideH)
end

function IsInside(x, y, insideX, insideY, insideW, insideH)
    return x > insideX and x < (insideX + insideW) and y > insideY and y <
               (insideY + insideH)
end

function CenterOnBox(width, height)
    local screenWidth, screenHeight = love.graphics.inverseTransformPoint(
                                          love.graphics.getDimensions())
    love.graphics.translate(screenWidth / 2 - width / 2,
                            screenHeight / 2 - height / 2)
end

function ColorWithOpacity(color, opacity)
    return color[1], color[2], color[3], opacity
end

function Text(table, attribute)
    local withLang = attribute .. "_" .. Language
    if table and table[withLang] then return table[withLang] end
    if table and table[attribute] then return table[attribute] end
    return ""
end

function Array(values)
    local result = {}
    for _, v in pairs(values) do table.insert(result, v) end
    return result
end

function Select(values, f)
    local result = {}
    for k, v in pairs(values) do result[k] = f(v) end
    return result
end

function ToDictionary(values, kf, vf)
    local result = {}
    for _, v in pairs(values) do result[kf(v)] = vf(v) end
    return result
end

function Keys(values)
    local result = {}
    for k, _ in pairs(values) do table.insert(result, k) end
    return result
end

function Take(values, count)
    local result = {}
    local take = count
    for k, v in pairs(values) do
        if take <= 0 then return result end
        take = take - 1
        result[k] = v
    end
    return result
end

function Sum(values)
    local result = 0
    for _, v in pairs(values) do result = result + v end
    return result
end

function Where(values, f)
    local result = {}
    for k, v in pairs(values) do if f(v) then result[k] = v end end
    return result
end

function Count(values, f)
    local count = 0
    for _, v in pairs(values) do if f(v) then count = count + 1 end end
    return count
end

function Max(values)
    local max = nil
    for i, v in pairs(values) do
        if max == nil then
            max = v
        else
            max = math.max(max, v)
        end
    end
    return max
end

function Any(values, f)
    for _, v in pairs(values) do if f(v) then return true end end
    return false
end

function ExceptValue(values, value)
    return Where(values, function(v) return v ~= value end)
end

local function insertAll(values, into)
    for k, v in pairs(values) do into[k] = v end
end

function Join(x)
    local result = {}
    for _, v in pairs(x) do insertAll(v, result) end
    return result
end

function ForEach(values, f)
    for _, v in pairs(values) do if v ~= nil then f(v) end end
end

function If(predicate, thenValue, elseValue)
    if predicate then return thenValue end
    return elseValue
end

function Shuffle(values)
    local result = {}
    for _, v in ipairs(Array(values)) do
        local pos = math.random(1, #result + 1)
        table.insert(result, pos, v)
    end
    return result
end

function GroupBy(values, groupF)
    local result = {}
    for _, v in pairs(values) do
        local groupValue = groupF(v)
        if result[groupValue] == nil then result[groupValue] = {} end
        table.insert(result[groupValue], v)
    end
    return result
end
