local game = require "model/game"
local test = {}

local duelModule = require "duel"
require "utils"

function test.new()
    local self = {}
    -- love.filesystem.setIdentity("screenshot_example")

    local duel = duelModule.new()

    function self.draw() duel.draw() end

    local function printScreen()
        -- love.graphics.captureScreenshot(os.time() .. ".png")
    end

    local sleep = 0
    local function runBot(game, dt)

        -- if game.currentPlayer() == game.player2() then
        --     return
        -- end

        sleep = sleep - dt
        if sleep > 0 then return end

        local function freePosition()
            for i = 1, 5 do
                if game.currentPlayer().board[i] == nil then
                    return i
                end
            end
            return nil
        end

        if game.ended() then
            print("Game over")
            -- sleep = 20
            duel = duelModule.new()
            return
        end

        if game.turnEnded() then return end

        if game.currentPlayer().played then

            if game.currentPlayer().casted then
                print("Card played and casted, end turn")
                game.endTurn()

                sleep = 0.2
                return
            else
                local casters = Shuffle(Where(game.currentPlayer().board,
                                       function(card)
                    return game.canCast(card)
                end))
                if #casters > 0 then
                    local caster = casters[1]
                    print("Cast with " .. caster.name)
                    game.cast(caster)

                    if game.isTargetingSpell() then
                        local potentialTargets = game.allCardsOnBoard()
                        for i, v in pairs(potentialTargets) do
                            game.selectCard(v)
                            if not game.isTargetingSpell() then
                                print("Casted on " .. v.name)
                                break
                            end
                        end
                    end

                end
                game.endTurn()
                return
            end
        end
        if freePosition() == nil then
            print("No room, end turn")
            game.endTurn()

            sleep = 0.2
            return
        end

        if game.currentPlayer().selectedCard == nil then
            print("Select a card")
            local playableCards = Shuffle(
                                      Where(game.currentPlayer().hand,
                                            function(card)
                    return game.cardIsPlayable(game.currentPlayer(), card)
                end))

            if not Any(playableCards, function(card) return true end) then
                print("No playable cards")
                game.endTurn()
                sleep = 5
                return
            end
            print("Select " .. playableCards[1].name)
            game.selectCard(playableCards[1])

            sleep = 0.2
            return
        else
            local position = freePosition()
            print("Play a card on " .. position)
            game.playCard(position)
            printScreen()
            sleep = 0.2
            return
        end

        print("Nothing to do")
        sleep = 0.2
    end

    function self.update(dt)
        runBot(duel.game, dt)

        duel.update(dt)
    end

    function self.keypressed(key, scancode, isrepeat)
        duel.keypressed(key, scancode, isrepeat)
    end

    return self
end

return test
