local stack = {}


function stack.new()
    local self = {}

    function self.push(value)
        table.insert(self, value)
    end

    function self.pop()
        return table.remove(self)
    end

    function self.contains(value)
        for _, v in pairs(self) do
            if v == value then
                return true
            end
        end
        return false
    end

    return self
end

return stack
