local buttons = require "buttons"
local decksFunctions = require "model/decks"
local duel = require "duel"
local bot = require "bot"

local newgame = {}

local columns = 6
local columnWidth = 150
local rowHeight = 50

local function drawDeckButtons(deckButtons, selectedDeck)
    love.graphics.push()
    for i, button in ipairs(deckButtons) do
        local column = (i - 1) % columns
        local row = math.floor((i - 1) / columns)
        love.graphics.push()
        love.graphics.translate(column * columnWidth, row * rowHeight)
        if button.deck == selectedDeck then
            love.graphics.draw(assets.frame_characters, -36, -33)
        end
        button:draw()
        love.graphics.pop()
    end
    love.graphics.pop()
end

local function deckButtons(decks, onDeckClick)
    return Select(decks, function(deck)
        local name = deck.name .. If(decksFunctions.isEmpty(deck), "", "*")
        local button = buttons.newButton(assets[deck.avatar], name,
                                         function() onDeckClick(deck) end)
        button.deck = deck
        return button
    end)
end

local deckScale = 0.7
local decksWidth = columnWidth * columns * deckScale
local decksHeight = 30 / columns * rowHeight * deckScale

local function drawPlayer(x, y, player)
    love.graphics.push()
    love.graphics.translate(x, y)
    love.graphics.scale(deckScale, deckScale)
    drawDeckButtons(player.buttons, player.deck)
    love.graphics.pop()
end

local function drawPlayerOptions(x, y, player)
    love.graphics.push()
    love.graphics.translate(x, y)
    player.botButton.draw()
    love.graphics.translate(player.botButton.getWidth() + 20, 0)

    -- ForEach(player.plusButtons, function(button)
    --     button.draw()
    --     love.graphics.translate(button.getWidth() + 15, 0)
    -- end)
    -- love.graphics.print("/ runda", 5, 5)
    love.graphics.pop()
end

local function newBotButton(player)
    return buttons.newToggleButton(function() return player.bot end, "Bot",
                                   function() player.bot = not player.bot end)
end

local function newPlusButton(player, plus)
    return buttons.newToggleButton(function() return player.perTurn == plus end,
                                   "+" .. plus,
                                   function() player.perTurn = plus end)
end

function newgame.new(onExit, changeMode)
    local self = {requireSpellSlot = false}

    local function onStart()
        if assets.soundtrack_menu then assets.soundtrack_menu:stop() end
        changeMode(duel.new(function() changeMode(self) end,
                            self.requireSpellSlot, self.player1, self.player2))
    end

    local closeButton = buttons.newButton(assets.close, "", onExit)
    local startButton = buttons.newButton(assets.accept, "Starta", onStart)

    local spellToggle = buttons.newToggleButton(
                            function() return self.requireSpellSlot end,
                            "Kräv plats för spells", function()
            self.requireSpellSlot = not self.requireSpellSlot
        end)

    local allDecks = decksFunctions.load()

    local function newPlayer()
        local player = {
            deck = allDecks[math.random(1, #allDecks)],
            bot = false,
            perTurn = 1
        }
        player.botButton = newBotButton(player)
        player.plusButtons = {
            newPlusButton(player, 1), newPlusButton(player, 2),
            newPlusButton(player, 3)
        }
        player.buttons = deckButtons(allDecks,
                                     function(deck) player.deck = deck end)
        return player
    end

    self.player1 = newPlayer()
    self.player2 = newPlayer()

    function self.draw()
        love.graphics.push()

        local screenWidth, screenHeight =
            love.graphics.inverseTransformPoint(love.graphics.getDimensions())

        love.graphics.translate(screenWidth - assets.close:getWidth() - 15, 15)
        closeButton.draw()
        love.graphics.translate(-startButton.getWidth() - 15, 0)
        startButton.draw()
        love.graphics.translate(-spellToggle.getWidth() - 40, 8)
        spellToggle.draw()
        love.graphics.pop()

        CenterOnBox(944, 500)
        local decksX = 944 / 2 - decksWidth / 2

        drawPlayer(decksX, 250 - decksHeight - 15, self.player1)
        drawPlayerOptions(decksX, 250 - 15, self.player1)
        love.graphics.push()
        -- CenterOnBox(assets.vs:getWidth(), assets.vs:getHeight())
        love.graphics.draw(assets.vs, 944 / 2 - assets.vs:getWidth() / 2,
                           250 - assets.vs:getHeight() / 2 + 15)
        love.graphics.pop()

        drawPlayer(decksX, 250 + 55, self.player2)
        drawPlayerOptions(decksX, 250 + 15, self.player2)
    end

    function self.update(dt)
        local event = events[#events]
        if event then event() end
        events = {}
    end

    return self
end

return newgame
