require "model/cards"
require "pickle"

local decks = {}

local decksFile = "decks"

local function getRandomHand()
    local aRandomHand, _ =
        DivideCardsEvenly(CardsByElement(Shuffle(AllCards())))
    local selection = {}
    for _, card in pairs(aRandomHand) do selection[card.name] = true end
    return selection
end

function decks.new() return {name = "Namn", cards = getRandomHand()} end
function decks.empty(name, avatar)
    return {name = name, avatar = avatar, cards = {}}
end
function decks.isEmpty(deck)
    if not deck.cards then return false end
    return not Any(deck.cards, function(selected) return selected == true end)
end
function decks.count() return #Avatars end

function decks.load()
    local contents, size = love.filesystem.read(decksFile)
    if contents == nil then
        local result = {}
        for i, character in ipairs(Characters) do
            result[i] = decks.empty(character.name, character.avatar)
        end
        return result
    end
    return unpickle(contents)
end

function decks.save(allDecks)
    local success, message = love.filesystem.write(decksFile, pickle(allDecks))
    if not success then print('Failed to save decks: ' .. message) end
end

return decks
