require "utils"

local earthCards = require "model/earthCards"
local airCards = require "model/airCards"
local lifeCards = require "model/lifeCards"
local waterCards = require "model/waterCards"
local deathCards = require "model/deathCards"
local fireCards = require "model/fireCards"

local createCardFunctions = Join {
    earthCards, airCards, lifeCards, waterCards, deathCards, fireCards
}

local function sortByElementAndLevel(a, b)
    if a.element == b.element then
        return a.level < b.level
    else
        return a.element > b.element
    end
end

function CreateCard(name)
    return createCardFunctions[string.gsub(string.lower(name), " ", "")]()
end

function AllCards()
    local allCards = Array(Select(createCardFunctions,
                                  function(f) return f() end))
    table.sort(allCards, sortByElementAndLevel)
    return allCards
end

function SortCards(cards)
    table.sort(cards, sortByElementAndLevel)
    return cards
end

function CardsByElement(cards)
    return GroupBy(cards, function(card) return card.element end)
end

function DivideCardsEvenly(cardsByElement)
    local hand1 = {}
    local hand2 = {}
    local elements = {"water", "fire", "air", "earth", "life", "death"}
    local cardsPerElement = 4
    for _, element in ipairs(elements) do
        for i = 1, cardsPerElement do
            if cardsByElement[element] ~= nil and #cardsByElement[element] >= 2 then
                table.insert(hand1, table.remove(cardsByElement[element]))
                table.insert(hand2, table.remove(cardsByElement[element]))
            end
        end
    end
    table.sort(hand1, sortByElementAndLevel)
    table.sort(hand2, sortByElementAndLevel)
    return hand1, hand2
end

function AllCardsForBoth() return AllCards(), AllCards() end

DivideCards = DivideCardsEvenly
