local duel = require "duel"
require "utils"
local buttons = require "buttons"
local decklist = require "decklist"
local newgame = require "newgame"

local menu = {}

function menu.new(changeMode)

    local self = {}

    local soundtrack = assets.soundtrack_menu

    local function backToMenu() changeMode(self) end

    local function openDecks()
        changeMode(decklist.new(changeMode, backToMenu))
    end
    local decksButton = buttons.newButton(assets.decks, "Kortlekar", openDecks)

    local backToMenu = function() changeMode(self) end

    function self.draw()
        if soundtrack and not soundtrack:isPlaying() then
            soundtrack:play()
        end

        local screenWidth, screenHeight =
            love.graphics.inverseTransformPoint(love.graphics.getDimensions())
        local menuWidth, menuHeight = assets.menu:getDimensions()

        love.graphics.translate(screenWidth / 2 - menuWidth / 2,
                                screenHeight / 2 - menuHeight / 2)
        love.graphics.draw(assets.menu)

        love.graphics.push()
        love.graphics.translate(0, 28)
        love.graphics.draw(assets.title)
        love.graphics.pop()

        love.graphics.push()
        love.graphics.translate(5, 278)
        if ClickedInside(0, 0, 100, 40) then
            table.insert(events, function()
                changeMode(newgame.new(backToMenu, changeMode))
            end)
        end
        love.graphics.draw(assets.new_game)
        love.graphics.translate(41, 10)
        love.graphics.print("Duell")
        love.graphics.pop()

        love.graphics.push()
        love.graphics.translate(376, 278)
        if ClickedInside(0, 0, 100, 40) then
            table.insert(events, function() love.event.quit() end)
        end
        love.graphics.draw(assets.quit)
        love.graphics.translate(41, 10)
        love.graphics.print("Avsluta")
        love.graphics.pop()

        love.graphics.push()
        love.graphics.translate(180, 278)
        decksButton.draw()
        love.graphics.pop()
    end

    function self.update(dt)
        local event = events[#events]
        if event then event() end
        events = {}
    end

    return self
end

return menu
