require "assets"
local duel = require "duel"
local test = require "test"
local menu = require "menu"
local decks = require "model/decks"
local deckbuilder = require "deckbuilder"
local decklist = require "decklist"

-- hint for editor that love exists
if love == nil then love = {} end

-- support either table.unpack or unpack
if table.unpack == nil and unpack ~= nil then table.unpack = unpack end

scale = 1
Language = "sv"

local function changeMode(newMode) Mode = newMode end

function love.load()

    math.randomseed(os.time())

    -- Let size of duel board determine scale for everything
    scale = duel.calculateScaleToFit()

    assets = LoadAssets()

    Mode = menu.new(changeMode)

    debug = false
    if debug then
        DivideCards = AllCardsForBoth
        GenerateElementPoints = GenerateDebugPoints
        Mode = duel.new(function() love.event.quit() end, false)
        -- mode = test.new()
    end

    -- aimCursor = love.mouse.newCursor("assets/aim_01.png", 50, 50)
    pointerCursor = love.mouse.getSystemCursor("arrow")
    targetCursor = love.mouse.getSystemCursor("crosshair")

    font = love.graphics.newFont(14)
    element_font = love.graphics.newFont(12)
    card_font = love.graphics.newFont(11)

    colors = {white = {255, 255, 255}, black = {0, 0, 0}}

    love.graphics.setFont(font)

    love.window.setVSync(1)

    mouse = {}
    events = {}
end

function love.draw()
    love.graphics.scale(scale, scale)

    Mode.draw()

    mouse.clicked = nil
end

function love.update(dt) Mode.update(dt) end

function love.keypressed(key, scancode, isrepeat)
    if Mode.keypressed ~= nil then Mode.keypressed(key, scancode, isrepeat) end
end

function love.mousepressed(x, y, button, istouch, presses)
    mouse.clicked = {}
    mouse.clicked.x = x
    mouse.clicked.y = y
end
