local buttons = require "buttons"
require "assets"
local deckbuilder = require "deckbuilder"
local decks = require "model/decks"

local decklist = {}

function decklist.new(changeMode, onExit)
    local self = {}

    local closeButton = buttons.newButton(assets.close, "", onExit)

    local deckCount = decks.count()
    local columns = 6
    local columnWidth = 150
    local rowHeight = 50

    function self.saveDecks()
        decks.save(self.allDecks)
        self.loadDecks()
    end

    function self.loadDecks()
        self.allDecks = decks.load()

        local function deckOpener(deck)
            return function() self.openBuilder(deck) end
        end

        self.deckbuttons = Select(self.allDecks, function(deck)
            local button = buttons.newButton(assets[deck.avatar], deck.name,
                                             deckOpener(deck))
            button.deck = deck
            return button
        end)
    end

    self.loadDecks()

    function self.openBuilder(deck)
        local function saveAndBack()
            self.saveDecks()
            changeMode(self)
        end
        local function discardAndBack()
            self.loadDecks()
            changeMode(self)
        end
        changeMode(deckbuilder.new(deck, saveAndBack, discardAndBack))
    end

    function self.draw()
        love.graphics.push()

        local screenWidth, _ = love.graphics.inverseTransformPoint(
                                   love.graphics.getDimensions())

        love.graphics.translate(screenWidth - assets.close:getWidth() - 15, 15)
        closeButton.draw()
        love.graphics.pop()

        CenterOnBox(columns * columnWidth, rowHeight * deckCount / columns)

        love.graphics.push()
        for i, button in ipairs(self.deckbuttons) do
            local column = (i - 1) % columns
            local row = math.floor((i - 1) / columns)
            local opacity = If(decks.isEmpty(button.deck), 0.6, 1)
            love.graphics.push("all")
            love.graphics.setColor(0xFF, 0xFF, 0xFF, opacity)
            love.graphics.translate(column * columnWidth, row * rowHeight)
            button:draw()
            love.graphics.pop()
        end
        love.graphics.pop()
    end

    function self.update(dt)
        for i, event in ipairs(events) do event() end
        events = {}
    end

    return self
end
return decklist
