local buttons = {}

function buttons.newToggleButton(isActive, label, onClick)
    local self = {}
    local margin = 5
    local boxSize = 15

    function self.getWidth()
        local font = love.graphics.getFont()
        return font:getWidth(label) + margin * 3
    end

    function self.draw()
        local font = love.graphics.getFont()
        love.graphics.print(label, 2 * margin + boxSize, margin)
        local width = self.getWidth()
        local height = font:getHeight() + margin * 2

        local style = If(isActive(), "fill", "line")
        love.graphics.rectangle(style, margin, margin, boxSize, boxSize)

        if ClickedInside(0, 0, width, height) then
            table.insert(events, onClick)
        end
    end

    return self
end

function buttons.newLabelButton(label, onClick)
    local self = {}
    local margin = 5

    function self.getWidth()
        local font = love.graphics.getFont()
        return font:getWidth(label) + margin * 2
    end

    function self.draw()
        local font = love.graphics.getFont()
        love.graphics.print(label, margin, margin)
        local width = self.getWidth()
        local height = font:getHeight() + margin * 2

        love.graphics.rectangle("line", 0, 0, width, height)

        if ClickedInside(0, 0, width, height) then
            table.insert(events, onClick)
        end
    end

    return self
end

function buttons.newButton(asset, label, onClick)
    local self = {}
    local separator = 5

    function self.getWidth()
        local font = love.graphics.getFont()
        return font:getWidth(label) + asset:getWidth() + separator
    end
    function self.draw()
        love.graphics.draw(asset)

        local font = love.graphics.getFont()
        love.graphics.print(label, asset:getWidth() + separator,
                            asset:getHeight() / 2 - font:getHeight(label) / 2)
        local width = self.getWidth()
        local height = asset:getHeight()
        if ClickedInside(0, 0, width, height) then
            table.insert(events, onClick)
        end
    end

    return self
end

local function newButton(asset, label, x, y, onClick)
    local self = {}
    local separator = 5

    function self.getWidth()
        local font = love.graphics.getFont()
        return font:getWidth(label) + asset:getWidth() + separator
    end
    function self.draw()
        love.graphics.push()
        love.graphics.translate(x, y)

        love.graphics.draw(asset)

        local font = love.graphics.getFont()
        love.graphics.print(label, asset:getWidth() + separator,
                            asset:getHeight() / 2 - font:getHeight(label) / 2)
        local width = self.getWidth()
        local height = asset:getHeight()
        if ClickedInside(0, 0, width, height) then
            table.insert(events, onClick)
        end

        love.graphics.pop()
    end

    return self
end

buttons.saveButton = {}
function buttons.saveButton.new(x, y, onClick)
    return newButton(assets.accept, "Spara", x, y, onClick)
end

buttons.closeButton = {}

function buttons.closeButton.getWidth() return assets.close:getWidth() end

function buttons.closeButton.new(x, y, onConfirmed)
    local self = {promptingForConfirmation = false}

    function self.draw()
        love.graphics.push()
        love.graphics.translate(x, y)

        love.graphics.draw(If(self.promptingForConfirmation, assets.accept,
                              assets.close))
        if ClickedInside(0, 0, 46, 40) then
            if self.promptingForConfirmation then
                table.insert(events, function()
                    self.promptingForConfirmation = false
                    onConfirmed()
                end)
            else
                table.insert(events, function()
                    self.promptingForConfirmation = true
                end)
            end
        elseif self.promptingForConfirmation and mouse.clicked then
            self.promptingForConfirmation = false
        end

        love.graphics.pop()
    end

    return self
end

return buttons
