local botController = {}
botController.new = function(game)
    local self = {sleep = 0}
    self.update = function(dt)

        self.sleep = self.sleep - dt
        if self.sleep > 0 then return end

        local function freePosition()
            for i = 1, 5 do
                if game.currentPlayer().board[i] == nil then
                    return i
                end
            end
            return nil
        end

        if game.ended() then return end

        if game.turnEnded() then return end

        if game.currentPlayer().played then

            if game.currentPlayer().casted then
                print("Card played and casted, end turn")
                game.endTurn()

                self.sleep = 0.2
                return
            else
                local casters = Shuffle(Where(game.currentPlayer().board,
                                              function(card)
                    return game.canCast(card)
                end))
                if #casters > 0 then
                    local caster = casters[1]
                    print("Cast with " .. caster.name)
                    game.cast(caster)

                    if game.isTargetingSpell() then
                        local potentialTargets = game.allCardsOnBoard()
                        for i, v in pairs(potentialTargets) do
                            game.selectCard(v)
                            if not game.isTargetingSpell() then
                                print("Casted on " .. v.name)
                                break
                            end
                        end
                    end

                end
                game.endTurn()
                return
            end
        end
        if freePosition() == nil then
            print("No room, end turn")
            game.endTurn()

            self.sleep = 0.2
            return
        end

        if game.currentPlayer().selectedCard == nil then
            print("Select a card")
            local playableCards = Shuffle(
                                      Where(game.currentPlayer().hand,
                                            function(card)
                    return game.cardIsPlayable(game.currentPlayer(), card)
                end))

            if not Any(playableCards, function(card) return true end) then
                print("No playable cards")
                game.endTurn()
                self.sleep = 5
                return
            end
            print("Select " .. playableCards[1].name)
            game.selectCard(playableCards[1])

            self.sleep = 0.2
            return
        else
            local position = freePosition()
            print("Play a card on " .. position)
            game.playCard(position)
            self.sleep = 0.2
            return
        end

        print("Nothing to do")
        self.sleep = 0.2

    end
    self.keypressed = function(key) end
    return self
end

return botController
