require "utils"

local images = {
    background = "assets/fight_screen.png",
    menu = "assets/menu_interface.png",
    title = "assets/title_pic_01.png",
    infoPanelBackground = "assets/info_panel.png",
    new_game = "assets/icon_newgame_active.png",
    decks = "assets/icon_decks_active.png",
    frame_characters = "assets/frame_characters.png",
    end_background = "assets/title_pic_intro.png",
    vs = "assets/vs.png",
    quit = "assets/icon_quit_active.png",
    close = "assets/button_x_act.png",
    accept = "assets/button_v_act.png",
    end_turn = "assets/button_end_turn.png",
    cast_button = "assets/cast_button_ready_01.png",
    cast_button_passive = "assets/cast_button_passive.png",

    element_water = "assets/elements/element_water.png",
    element_fire = "assets/elements/element_fire.png",
    element_earth = "assets/elements/element_earth.png",
    element_air = "assets/elements/element_air.png",
    element_life = "assets/elements/element_life.png",
    element_death = "assets/elements/element_death.png",

    -- Avatars
    avatar_air_01 = "assets/avatars/avatar_air_01.png",
    avatar_air_02 = "assets/avatars/avatar_air_02.png",
    avatar_air_03 = "assets/avatars/avatar_air_03.png",
    avatar_air_04 = "assets/avatars/avatar_air_04.png",
    avatar_air_05 = "assets/avatars/avatar_air_05.png",
    avatar_death_01 = "assets/avatars/avatar_death_01.png",
    avatar_death_02 = "assets/avatars/avatar_death_02.png",
    avatar_death_03 = "assets/avatars/avatar_death_03.png",
    avatar_death_04 = "assets/avatars/avatar_death_04.png",
    avatar_death_05 = "assets/avatars/avatar_death_05.png",
    avatar_earth_01 = "assets/avatars/avatar_earth_01.png",
    avatar_earth_02 = "assets/avatars/avatar_earth_02.png",
    avatar_earth_03 = "assets/avatars/avatar_earth_03.png",
    avatar_earth_04 = "assets/avatars/avatar_earth_04.png",
    avatar_earth_05 = "assets/avatars/avatar_earth_05.png",
    avatar_fire_01 = "assets/avatars/avatar_fire_01.png",
    avatar_fire_02 = "assets/avatars/avatar_fire_02.png",
    avatar_fire_03 = "assets/avatars/avatar_fire_03.png",
    avatar_fire_04 = "assets/avatars/avatar_fire_04.png",
    avatar_fire_05 = "assets/avatars/avatar_fire_05.png",
    avatar_life_01 = "assets/avatars/avatar_life_01.png",
    avatar_life_02 = "assets/avatars/avatar_life_02.png",
    avatar_life_03 = "assets/avatars/avatar_life_03.png",
    avatar_life_04 = "assets/avatars/avatar_life_04.png",
    avatar_life_05 = "assets/avatars/avatar_life_05.png",
    avatar_water_01 = "assets/avatars/avatar_water_01.png",
    avatar_water_02 = "assets/avatars/avatar_water_02.png",
    avatar_water_03 = "assets/avatars/avatar_water_03.png",
    avatar_water_04 = "assets/avatars/avatar_water_04.png",
    avatar_water_05 = "assets/avatars/avatar_water_05.png",

    -- Card icons
    icon_stone = "assets/cardicons/cardicon_stoneskin.png",
    icon_bless = "assets/cardicons/cardicon_bless.png",
    icon_poison = "assets/cardicons/cardicon_poison.png",
    icon_absolutedefence = "assets/cardicons/cardicon_absolutedefense.png",
    icon_fireshield = "assets/cardicons/cardicon_fireshield.png",
    icon_bloodlust = "assets/cardicons/cardicon_bloodlust.png",
    icon_bloodrage = "assets/cardicons/cardicon_bloodrage.png",
    icon_spellbreaker = "assets/cardicons/cardicon_spellbreaker.png",
    icon_paralyze = "assets/cardicons/cardicon_petrification.png",
    icon_weakness = "assets/cardicons/cardicon_weakness.png",

    -- Earth cards
    card_satyr = "assets/cards/card_earth_satyr.png",
    card_golem = "assets/cards/card_earth_golem.png",
    card_centaur = "assets/cards/card_earth_centaur.png",
    card_dryad = "assets/cards/card_earth_dryad.png",
    card_echidna = "assets/cards/card_earth_echidna.png",
    card_elemental = "assets/cards/card_earth_elemental.png",
    card_ent = "assets/cards/card_earth_ent.png",
    card_forestspirit = "assets/cards/card_earth_forestspirit.png",

    card_earthquake = "assets/spells/spell_earthquake.png",
    card_revival = "assets/spells/spell_revival.png",
    card_absolutedefence = "assets/spells/spell_absolutedefence.png",
    card_quicksand = "assets/spells/spell_quicksands.png",
    card_restructure = "assets/spells/spell_restructure.png",

    -- Fire cards
    card_cerberus = "assets/cards/card_fire_cerberus.png",
    card_demon = "assets/cards/card_fire_demon.png",
    card_devil = "assets/cards/card_fire_devil.png",
    card_efreet = "assets/cards/card_fire_efreet.png",
    card_firelord = "assets/cards/card_fire_firelord.png",
    card_reddrake = "assets/cards/card_fire_reddrake.png",
    card_salamander = "assets/cards/card_fire_salamandra.png",
    card_vulcan = "assets/cards/card_fire_vulcan.png",

    card_armageddon = "assets/spells/spell_armageddon.png",
    card_fireball = "assets/spells/spell_fireball.png",
    card_firespikes = "assets/spells/spell_firespikes.png",
    card_flamearrow = "assets/spells/spell_flamearrow.png",
    card_ritualfire = "assets/spells/spell_ritualfire.png",

    -- Air cards
    card_fairy = "assets/cards/card_air_fairy.png",
    card_gargoyle = "assets/cards/card_air_gargoyle.png",
    card_manticore = "assets/cards/card_air_manticore.png",
    card_nymph = "assets/cards/card_air_nymph.png",
    card_phoenix = "assets/cards/card_air_phoenix.png",
    card_titan = "assets/cards/card_air_titan.png",
    card_zeus = "assets/cards/card_air_zeus.png",

    card_blackwind = "assets/spells/spell_blackwind.png",
    card_lightning = "assets/spells/spell_lighting.png",
    card_plague = "assets/spells/spell_plague.png",
    card_spellbreaker = "assets/spells/spell_spellbreaker.png",

    -- Life cards
    card_apostate = "assets/cards/card_life_apostate.png",
    card_chimera = "assets/cards/card_life_chimera.png",
    card_magichealer = "assets/cards/card_life_magichealer.png",
    card_paladin = "assets/cards/card_life_paladin.png",
    card_pegasus = "assets/cards/card_life_pegasus.png",
    card_priest = "assets/cards/card_life_priest.png",
    card_unicorn = "assets/cards/card_life_unicorn.png",

    card_bless = "assets/spells/spell_bless.png",
    card_purify = "assets/spells/spell_purify.png",
    card_godswrath = "assets/spells/spell_godswrath.png",
    card_lifesacrifice = "assets/spells/spell_lifesacrifice.png",
    card_rejuvenation = "assets/spells/spell_rejuvenation.png",

    -- Death cards
    card_banshee = "assets/cards/card_death_banshee.png",
    card_darklord = "assets/cards/card_death_darklord.png",
    card_ghost = "assets/cards/card_death_ghost.png",
    card_grimreaper = "assets/cards/card_death_grimreaper.png",
    card_lich = "assets/cards/card_death_lich.png",
    card_vampire = "assets/cards/card_death_vampire.png",
    card_werewolf = "assets/cards/card_death_werewolf.png",
    card_zombie = "assets/cards/card_death_zombie.png",

    card_chaosvortex = "assets/spells/spell_chaosvortex.png",
    card_coverofdarkness = "assets/spells/spell_coverofdarkness.png",
    card_curse = "assets/spells/spell_curse.png",
    card_steallife = "assets/spells/spell_steallife.png",
    card_totalweakness = "assets/spells/spell_totalweakness.png",

    -- Water cards
    card_hydra = "assets/cards/card_water_hydra.png",
    card_iceguard = "assets/cards/card_water_iceguard.png",
    card_icewizard = "assets/cards/card_water_icewizard.png",
    card_leviathan = "assets/cards/card_water_leviathan.png",
    card_nixie = "assets/cards/card_water_nixie.png",
    card_poseidon = "assets/cards/card_water_poseidon.png",
    card_waterfall = "assets/cards/card_water_waterfall.png",

    card_acidstorm = "assets/spells/spell_acidstorm.png",
    card_icebolt = "assets/spells/spell_icebolt.png",
    card_paralyze = "assets/spells/spell_paralize.png",
    card_seajustice = "assets/spells/spell_seajustice.png",
    card_poison = "assets/spells/spell_poison.png"
}

local sounds = {
    select = "assets/sounds/bip2.wav",
    spell = "assets/sounds/spell.wav",
    summon = "assets/sounds/card_summon.wav",
    cast = "assets/sounds/card_cast.wav",
    dies = "assets/sounds/card_die.wav",
    attack = "assets/sounds/card_attack.wav",
    startturn = "assets/sounds/bookopen.wav",
    soundtrack = "assets/sounds/fight.mp3",
    soundtrack_menu = "assets/sounds/map.mp3"
}

CharacterNames = {
    "Arhmaster", "Fernando", "Elfinger", "Gerghud", "Selena", "Marfera",
    "Ignador", "Pentacle", "Clandalf", "Veland", "Tallar", "Greyg", "Osvinn",
    "Zera", "Argos", "Akteon", "Morphey", "Kefal", "Virtus", "Giperion",
    "Gimeney", "Atropos", "Oristey", "Patrokl", "Orphey", "Iason", "Valiant",
    "Roland", "Fernando", "Elfinger", "Gector", "Semphiro", "Alkazar",
    "Kentaro", "Miligan", "Gektor", "Efiloney", "Tungus", "Saturno", "Chronos",
    "Tefida", "Demetra", "Avridya", "Fionia", "Diona", "Antea", "Theia",
    "Padla", "Orchiid", "Hordamned", "Zarghul", "Zealon", "Ilmorg", "Morgant",
    "Dorgon", "Velthar", "Ozerthu", "Thukhu", "Platzron", "Fearfal", "Zlo",
    "Murena", "Khlone", "Mordian", "Zargul", "Archimond", "Tilmorg", "Moaran",
    "Nertigont", "Acromarh", "Acheron", "Borg", "Gentigal", "Atomakr",
    "Garlina", "Proxiphea", "Koktida", "Nebire", "Memfida", "Nemezida",
    "Orseida", "Macabra"
}

Avatars = {
    "avatar_air_01", "avatar_air_02", "avatar_air_03", "avatar_air_04",
    "avatar_air_05", "avatar_death_01", "avatar_death_02", "avatar_death_03",
    "avatar_death_04", "avatar_death_05", "avatar_earth_01", "avatar_earth_02",
    "avatar_earth_03", "avatar_earth_04", "avatar_earth_05", "avatar_fire_01",
    "avatar_fire_02", "avatar_fire_03", "avatar_fire_04", "avatar_fire_05",
    "avatar_life_01", "avatar_life_02", "avatar_life_03", "avatar_life_04",
    "avatar_life_05", "avatar_water_01", "avatar_water_02", "avatar_water_03",
    "avatar_water_04", "avatar_water_05"
}

Characters = {
    {name = "Arhmaster", avatar = "avatar_air_01"},
    {name = "Elfinger", avatar = "avatar_air_02"},
    {name = "Fernando", avatar = "avatar_air_03"},
    {name = "Gerghud", avatar = "avatar_air_04"},
    {name = "Oristey", avatar = "avatar_air_05"},
    {name = "Marfera", avatar = "avatar_death_01"},
    {name = "Ignador", avatar = "avatar_death_02"},
    {name = "Pentacle", avatar = "avatar_death_03"},
    {name = "Clandalf", avatar = "avatar_death_04"},
    {name = "Veland", avatar = "avatar_death_05"},
    {name = "Tallar", avatar = "avatar_earth_01"},
    {name = "Greyg", avatar = "avatar_earth_02"},
    {name = "Osvinn", avatar = "avatar_earth_03"},
    {name = "Virtus", avatar = "avatar_earth_04"},
    {name = "Argos", avatar = "avatar_earth_05"},
    {name = "Akteon", avatar = "avatar_fire_01"},
    {name = "Morphey", avatar = "avatar_fire_02"},
    {name = "Kefal", avatar = "avatar_fire_03"},
    {name = "Zera", avatar = "avatar_fire_04"},
    {name = "Giperion", avatar = "avatar_fire_05"},
    {name = "Gimeney", avatar = "avatar_life_01"},
    {name = "Atropos", avatar = "avatar_life_02"},
    {name = "Selena", avatar = "avatar_life_03"},
    {name = "Patrokl", avatar = "avatar_life_04"},
    {name = "Orphey", avatar = "avatar_life_05"},
    {name = "Iason", avatar = "avatar_water_01"},
    {name = "Valiant", avatar = "avatar_water_02"},
    {name = "Roland", avatar = "avatar_water_03"},
    {name = "Demetra", avatar = "avatar_water_04"},
    {name = "Morgant", avatar = "avatar_water_05"}
}

local function loadSound(file) return love.audio.newSource(file, "static") end

function LoadAssets()
    return Join {
        Select(images, love.graphics.newImage), Select(sounds, loadSound)
    }
end

function CardImage(assets, name)
    return assets["card_" .. string.lower(string.gsub(name, " ", ""))]
end
